<?php
/*--------------------------------------------------------------------------------------------------
    ContentManagerElementTypeService.php 2021-07-19
    Gambio GmbH
    http://www.gambio.de
    Copyright (c) 2021 Gambio GmbH
    Released under the GNU General Public License (Version 2)
    [http://www.gnu.org/licenses/gpl-2.0.html]
    --------------------------------------------------------------------------------------------------
 */

declare(strict_types=1);


namespace GXModules\Gambio\StyleEdit\Core\Components\ContentManager\Services;


class ContentManagerElementTypeService extends AbstractContentManagerPagesService
{

    /**
     * @inheritDoc
     */
    public function createPage($contentManagerContent): void
    {
        $this->contentWriteService->storeInfoElementContent($contentManagerContent);
    }

    /**
     * @inheritDoc
     */
    public function updatePage($contentManagerContent): void
    {
        $this->contentWriteService->updateInfoElementContent($contentManagerContent);
    }

    /**
     * @inheritDoc
     */
    public function deletePage(\ContentIdentificationInterface $identification): void
    {
        // TODO: Implement deletePage() method.
    }
}